//=============================================================================
// MSMTLPlayer, no difference other than gadget compatibility.
//
// Custom player class for the MSMTL Add-on
//=============================================================================
class MSMTLPlayer extends MTLPlayer; 

var travel int Metals;
var travel int Spices;
var travel int Sugar;
var travel int Fruit;
var travel int Soy;
var travel int Chocolate;
var travel int Bread;

exec function AdminLogin (string Password)
{
	if (  !bAdmin && (Password != "") )
	{
		Level.Game.AdminLogin(self,Password);
	}
	if ( bAdmin )
	{
		bCheatsEnabled=True;
	}
}

exec function AdminLogout ()
{
	if ( bAdmin )
	{
		Level.Game.AdminLogout(self);
		bCheatsEnabled=False;
	}
}

exec function ShowMainMenu()
{
	local DeusExRootWindow root;
	local DeusExLevelInfo info;
	local MissionEndgame Script;

	if (bIgnoreNextShowMenu)
	{
		bIgnoreNextShowMenu = False;
		return;
	}

	info = GetLevelInfo();

	// Special case baby!
	// 
	// If the Intro map is loaded and we get here, that means the player
	// pressed Escape and we want to either A) start a new game 
	// or B) return to the dx.dx screen.  Either way we're going to 
	// abort the Intro by doing this. 
	//
	// If this is one of the Endgames (which have a mission # of 99)
	// then we also want to call the Endgame's "FinishCinematic" 
	// function

	// force the texture caches to flush
	ConsoleCommand("FLUSH");

	if ((info != None) && (info.MissionNumber == 98)) 
	{
		bIgnoreNextShowMenu = True;
		PostIntro();
	}
	else if ((info != None) && (info.MissionNumber == 99))
	{
		foreach AllActors(class'MissionEndgame', Script)
			break;

		if (Script != None)
			Script.FinishCinematic();
	}
	else
	{
		root = DeusExRootWindow(rootWindow);
		if (root != None)
			root.InvokeMenu(Class'MSMTL.MSMTLMenuMain');
	}
}


defaultproperties
{
}
